/*
 * Decompiled with CFR 0.152.
 */
package fr.iglee42.createcasing.compatibility.createextendedcogs;

import com.jozufozu.flywheel.core.PartialModel;
import com.rabbitminers.extendedgears.base.data.ICogwheelMaterial;
import com.rabbitminers.extendedgears.base.data.MetalCogwheel;
import com.rabbitminers.extendedgears.base.data.WoodenCogwheel;
import com.rabbitminers.extendedgears.base.datatypes.CogwheelModel;
import com.rabbitminers.extendedgears.cogwheels.CustomCogwheelBlock;
import com.rabbitminers.extendedgears.cogwheels.HalfShaftCogwheelBlock;
import com.rabbitminers.extendedgears.cogwheels.ICustomCogwheel;
import com.rabbitminers.extendedgears.cogwheels.ShaftlessCogwheelBlock;
import com.simibubi.create.AllBlockPartials;
import com.simibubi.create.content.contraptions.base.CasingBlock;
import com.simibubi.create.content.contraptions.base.KineticTileEntity;
import com.simibubi.create.content.contraptions.relays.elementary.SimpleKineticTileEntity;
import com.simibubi.create.content.contraptions.relays.encased.EncasedCogwheelBlock;
import com.tterrag.registrate.util.entry.BlockEntry;
import fr.iglee42.createcasing.compatibility.createextendedcogs.CreateExtendedCogwheelsCompat;
import fr.iglee42.createcasing.compatibility.createextendedcogs.CreateExtendedCogwheelsPartials;
import java.util.Arrays;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class CustomCogwheelCompat
extends EncasedCogwheelBlock
implements ICustomCogwheel {
    private final CustomCogwheelBlock cogwheel;
    private final HalfShaftCogwheelBlock halfCog;
    private final ShaftlessCogwheelBlock shaftlessCog;

    public CustomCogwheelCompat(boolean large, BlockBehaviour.Properties properties, BlockEntry<CasingBlock> casing, CustomCogwheelBlock cogwheel, HalfShaftCogwheelBlock halfCog, ShaftlessCogwheelBlock shaftlessCog) {
        super(large, properties, casing);
        this.cogwheel = cogwheel;
        this.halfCog = halfCog;
        this.shaftlessCog = shaftlessCog;
    }

    public ICogwheelMaterial getMaterial() {
        return this.cogwheel.getMaterial();
    }

    public PartialModel getPartialModelType() {
        PartialModel model;
        PartialModel partialModel = model = this.isLargeCog() ? AllBlockPartials.SHAFTLESS_LARGE_COGWHEEL : AllBlockPartials.SHAFTLESS_COGWHEEL;
        if (this.getWoodenCogwheel(this.cogwheel.getMaterial().asId()) != null) {
            CogwheelModel cogModel = CreateExtendedCogwheelsPartials.SHAFTLESS_WOODEN_COGWHEELS.get(this.getWoodenCogwheel(this.cogwheel.getMaterial().asId()));
            model = this.isLargeCog() ? cogModel.large() : cogModel.small();
        } else {
            CogwheelModel cogModel = CreateExtendedCogwheelsPartials.SHAFTLESS_METAL_COGWHEELS.get(this.getMetalCogwheel(this.cogwheel.getMaterial().asId()));
            model = this.isLargeCog() ? cogModel.large() : cogModel.small();
        }
        return model;
    }

    public WoodenCogwheel getWoodenCogwheel(String id) {
        return Arrays.stream(WoodenCogwheel.values()).filter(c -> c.asId().equals(id.toLowerCase())).findFirst().orElse(null);
    }

    public MetalCogwheel getMetalCogwheel(String id) {
        return Arrays.stream(MetalCogwheel.values()).filter(c -> c.asId().equals(id.toLowerCase())).findFirst().orElse(null);
    }

    public BlockEntityType<? extends SimpleKineticTileEntity> getTileEntityType() {
        return (BlockEntityType)CreateExtendedCogwheelsCompat.COGWHEEL.get();
    }

    public InteractionResult onSneakWrenched(BlockState state, UseOnContext context) {
        if (!context.m_43725_().f_46443_) {
            context.m_43725_().m_46796_(2001, context.m_8083_(), Block.m_49956_((BlockState)state));
            KineticTileEntity.switchToBlockState((Level)context.m_43725_(), (BlockPos)context.m_8083_(), (BlockState)((BlockState)this.cogwheel.m_49966_().m_61124_((Property)AXIS, (Comparable)((Direction.Axis)state.m_61143_((Property)AXIS)))));
        }
        return InteractionResult.SUCCESS;
    }

    public CustomCogwheelBlock getCogwheel() {
        return this.cogwheel;
    }

    public HalfShaftCogwheelBlock getHalfCog() {
        return this.halfCog;
    }

    public ShaftlessCogwheelBlock getShaftlessCog() {
        return this.shaftlessCog;
    }
}

